<?php
// header.php
if (!isset($appName)) {
    $appName = 'Beatstore Demo PHP';
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo e($appName); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        :root {
            --bg: #050816;
            --bg-alt: #0b1020;
            --accent: #5b8def;
            --accent-soft: rgba(91,141,239,0.15);
            --text: #f5f5ff;
            --text-muted: #9ba0c2;
            --danger: #ff4d6a;
            --radius-lg: 18px;
            --radius-sm: 10px;
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #161b3b 0, #050816 45%, #02010b 100%);
            color: var(--text);
        }
        a { color: var(--accent); text-decoration: none; }
        a:hover { text-decoration: underline; }

        .layout {
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        header {
            padding: 16px 24px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            border-bottom: 1px solid rgba(255,255,255,0.05);
            backdrop-filter: blur(16px);
            position: sticky;
            top: 0;
            z-index: 20;
            background: linear-gradient(to bottom, rgba(5,8,22,0.95), rgba(5,8,22,0.75));
        }
        .brand {
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .brand-logo {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            background: conic-gradient(from 180deg, #5b8def, #ff6bb5, #ffd66b, #5b8def);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 700;
            font-size: 18px;
            color: #050816;
        }
        .brand-title {
            font-weight: 600;
            letter-spacing: 0.06em;
            font-size: 14px;
            text-transform: uppercase;
        }
        .nav-links {
            display: flex;
            gap: 16px;
            font-size: 14px;
        }
        .nav-links a {
            color: var(--text-muted);
            padding: 6px 10px;
            border-radius: 999px;
            text-decoration: none;
        }
        .nav-links a:hover {
            background: rgba(255,255,255,0.06);
            color: var(--text);
        }
        main {
            padding: 24px;
            max-width: 1080px;
            margin: 0 auto;
            width: 100%;
            flex: 1;
        }
        .hero {
            margin-bottom: 24px;
            padding: 20px 20px 18px;
            border-radius: var(--radius-lg);
            background: radial-gradient(circle at top left, rgba(91,141,239,0.35), transparent 60%),
                        radial-gradient(circle at bottom right, rgba(255,107,181,0.25), transparent 60%),
                        linear-gradient(135deg, #050816, #0b1020);
            border: 1px solid rgba(255,255,255,0.08);
            display: flex;
            flex-wrap: wrap;
            gap: 16px;
            align-items: center;
            justify-content: space-between;
        }
        .hero-text h1 {
            margin: 0 0 10px;
            font-size: clamp(22px, 3vw, 28px);
        }
        .hero-text p {
            margin: 0;
            font-size: 14px;
            color: var(--text-muted);
        }
        .hero-pill {
            background: rgba(5,8,22,0.65);
            padding: 8px 14px;
            border-radius: 999px;
            border: 1px solid rgba(255,255,255,0.12);
            font-size: 12px;
            color: var(--text-muted);
        }

        .card-grid {
            display: grid;
            gap: 16px;
        }
        @media (min-width: 720px) {
            .card-grid {
                grid-template-columns: repeat(2, minmax(0, 1fr));
            }
        }
        .card {
            background: var(--bg-alt);
            border-radius: var(--radius-lg);
            padding: 16px 16px 14px;
            border: 1px solid rgba(255,255,255,0.05);
            box-shadow: 0 18px 40px rgba(0,0,0,0.45);
        }
        .card-header {
            display: flex;
            justify-content: space-between;
            gap: 10px;
            align-items: baseline;
            margin-bottom: 10px;
        }
        .card-title {
            font-weight: 600;
            font-size: 15px;
        }
        .badge {
            display: inline-flex;
            align-items: center;
            padding: 3px 8px;
            border-radius: 999px;
            background: rgba(255,255,255,0.05);
            font-size: 11px;
            color: var(--text-muted);
        }
        .meta {
            font-size: 12px;
            color: var(--text-muted);
            display: flex;
            gap: 8px;
            margin-bottom: 8px;
        }
        .description {
            font-size: 13px;
            color: var(--text-muted);
            margin-bottom: 10px;
        }
        audio {
            width: 100%;
            margin-bottom: 10px;
        }
        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
            padding: 8px 14px;
            border-radius: 999px;
            border: none;
            cursor: pointer;
            font-size: 13px;
            font-weight: 500;
            text-decoration: none;
            transition: transform 0.08s ease, box-shadow 0.08s ease, background 0.08s ease;
        }
        .btn-primary {
            background: var(--accent);
            color: #050816;
            box-shadow: 0 10px 25px rgba(91,141,239,0.45);
        }
        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 16px 30px rgba(91,141,239,0.6);
        }
        .btn-ghost {
            background: transparent;
            color: var(--text-muted);
            border: 1px solid rgba(255,255,255,0.1);
        }
        .btn-ghost:hover {
            background: rgba(255,255,255,0.06);
            color: var(--text);
        }
        .price-tag {
            font-size: 14px;
            font-weight: 600;
        }
        .pill {
            font-size: 11px;
            border-radius: 999px;
            padding: 3px 8px;
            background: var(--accent-soft);
            color: var(--accent);
        }
        .license-options {
            margin: 8px 0 10px;
            padding: 10px;
            border-radius: var(--radius-sm);
            background: rgba(255,255,255,0.02);
            border: 1px solid rgba(255,255,255,0.06);
        }
        .license-options label {
            display: flex;
            justify-content: space-between;
            gap: 6px;
            align-items: center;
            font-size: 13px;
            margin-bottom: 6px;
            cursor: pointer;
        }
        .license-options small {
            display: block;
            color: var(--text-muted);
            font-size: 11px;
        }
        .form-group {
            margin-bottom: 10px;
        }
        .form-group label {
            font-size: 13px;
            display: block;
            margin-bottom: 4px;
        }
        .form-control {
            width: 100%;
            padding: 7px 9px;
            border-radius: 10px;
            border: 1px solid rgba(255,255,255,0.12);
            background: rgba(5,8,22,0.9);
            color: var(--text);
            font-size: 13px;
        }
        .form-control:focus {
            outline: none;
            border-color: var(--accent);
            box-shadow: 0 0 0 1px rgba(91,141,239,0.4);
        }
        .alert {
            font-size: 12px;
            padding: 8px 10px;
            border-radius: var(--radius-sm);
            margin-bottom: 10px;
        }
        .alert-info {
            background: rgba(91,141,239,0.12);
            border: 1px solid rgba(91,141,239,0.4);
            color: var(--text);
        }
        .alert-danger {
            background: rgba(255,77,106,0.08);
            border: 1px solid rgba(255,77,106,0.55);
            color: var(--danger);
        }
        .contract-box {
            font-size: 11px;
            color: var(--text-muted);
            padding: 8px 9px;
            border-radius: var(--radius-sm);
            background: rgba(255,255,255,0.02);
            border: 1px dashed rgba(255,255,255,0.12);
        }
        footer {
            padding: 14px 24px;
            font-size: 11px;
            color: var(--text-muted);
            border-top: 1px solid rgba(255,255,255,0.04);
            text-align: center;
        }
    </style>
</head>
<body>
<div class="layout">
<header>
    <div class="brand">
        <div class="brand-logo">B</div>
        <div>
            <div class="brand-title">Beatstore Demo</div>
            <div style="font-size:11px; color:var(--text-muted);">
                Beats licenciados para creadores serios
            </div>
        </div>
    </div>
    <nav class="nav-links">
        <a href="index.php">Beats</a>
        <a href="checkout.php">Checkout</a>
    </nav>
</header>
<main>
