<?php
require_once 'config.php';

$infoMsg = '';
$errorMsg = '';

if (isset($_GET['logout'])) {
    unset($_SESSION['is_admin']);
    header('Location: admin.php');
    exit;
}

// Login admin (demo)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'login') {
    $password = $_POST['password'] ?? '';
    // Clave de demo
    if ($password === 'demo123') {
        $_SESSION['is_admin'] = true;
        header('Location: admin.php');
        exit;
    } else {
        $errorMsg = 'Clave incorrecta. Usa la clave de demo indicada.';
    }
}

// Crear nuevo beat
if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['action'] ?? '') === 'create' && !empty($_SESSION['is_admin'])) {
    $title       = trim($_POST['title'] ?? '');
    $genre       = trim($_POST['genre'] ?? '');
    $bpm         = (int)($_POST['bpm'] ?? 0);
    $basePrice   = (float)($_POST['base_price'] ?? 0);
    $demoUrl     = trim($_POST['demo_url'] ?? '');
    $fullUrl     = trim($_POST['full_url'] ?? '');
    $description = trim($_POST['description'] ?? '');

    if ($title === '' || $genre === '' || $bpm <= 0 || $basePrice <= 0 || $demoUrl === '' || $fullUrl === '') {
        $errorMsg = 'Por favor completa todos los campos obligatorios para crear el beat.';
    } else {
        $beats = loadBeats();
        $maxId = 0;
        foreach ($beats as $b) {
            if ($b['id'] > $maxId) $maxId = $b['id'];
        }
        $id = $maxId + 1;
        $slug = slugify($title);

        $beats[$id] = [
            'id'          => $id,
            'title'       => $title,
            'slug'        => $slug,
            'genre'       => $genre,
            'bpm'         => $bpm,
            'base_price'  => $basePrice,
            'demo_url'    => $demoUrl,
            'full_url'    => $fullUrl,
            'description' => $description !== '' ? $description : ('Beat ' . $title),
        ];

        saveBeats($beats);
        // recargar beats en variable global
        $GLOBALS['beats'] = loadBeats();
        $infoMsg = 'Beat creado correctamente. Ahora aparecerá en la tienda.';
    }
}

require_once 'header.php';

$isAdmin = !empty($_SESSION['is_admin']);
?>
<div class="card">
    <div class="card-header">
        <div>
            <div class="card-title">Panel administrativo (demo)</div>
            <div class="meta">
                <span>Crear y gestionar beats a la venta</span>
            </div>
        </div>
        <div>
            <?php if ($isAdmin): ?>
                <a href="admin.php?logout=1" class="btn btn-ghost">Cerrar sesión</a>
            <?php endif; ?>
        </div>
    </div>

    <?php if (!$isAdmin): ?>
        <p class="description">
            Este es un <strong>acceso de demostración</strong> para el panel administrativo. No hay roles ni usuarios,
            solo una clave de prueba para ver cómo se podrían crear nuevos productos (beats) desde una interfaz simple.
        </p>

        <?php if ($errorMsg): ?>
            <div class="alert alert-danger"><?php echo e($errorMsg); ?></div>
        <?php endif; ?>

        <form method="post">
            <input type="hidden" name="action" value="login">
            <div class="form-group">
                <label for="password">Clave de acceso (demo)</label>
                <input class="form-control" type="password" id="password" name="password" placeholder="demo123" required>
            </div>
            <div style="display:flex; justify-content:flex-end;">
                <button type="submit" class="btn btn-primary">Entrar</button>
            </div>
        </form>

        <div class="contract-box" style="margin-top:10px;">
            <strong>Tip:</strong> En un sistema real, aquí habría un login con usuarios, roles (productor, admin),
            recuperación de contraseña, etc. Para esta demo usamos solo una clave fija: <code>demo123</code>.
        </div>
    <?php else: ?>
        <?php if ($infoMsg): ?>
            <div class="alert alert-success"><?php echo e($infoMsg); ?></div>
        <?php endif; ?>
        <?php if ($errorMsg): ?>
            <div class="alert alert-danger"><?php echo e($errorMsg); ?></div>
        <?php endif; ?>

        <p class="description">
            Desde aquí puedes ver los beats que existen en el sistema y crear nuevos productos a la venta. Los datos se
            guardan en un archivo JSON sencillo, ideal para un prototipo rápido sin base de datos.
        </p>

        <h2 style="font-size:14px; margin:12px 0 6px;">Beats actuales</h2>
        <div style="overflow-x:auto; margin-bottom:14px;">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Título</th>
                        <th>Género</th>
                        <th>BPM</th>
                        <th>Precio base</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach (getAllBeats() as $b): ?>
                        <tr>
                            <td><?php echo e($b['id']); ?></td>
                            <td><?php echo e($b['title']); ?></td>
                            <td><?php echo e($b['genre']); ?></td>
                            <td><?php echo e($b['bpm']); ?></td>
                            <td>$<?php echo number_format($b['base_price'], 2); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <h2 style="font-size:14px; margin:12px 0 6px;">Crear nuevo beat</h2>
        <form method="post">
            <input type="hidden" name="action" value="create">
            <div class="card" style="padding:12px; margin-top:4px;">
                <div class="form-group">
                    <label for="title">Título del beat *</label>
                    <input class="form-control" type="text" id="title" name="title" required>
                </div>
                <div class="form-group">
                    <label for="genre">Género / Mood *</label>
                    <input class="form-control" type="text" id="genre" name="genre" placeholder="Trap, Lo-fi, Afrobeat..." required>
                </div>
                <div class="form-group">
                    <label for="bpm">BPM *</label>
                    <input class="form-control" type="number" id="bpm" name="bpm" min="40" max="220" required>
                </div>
                <div class="form-group">
                    <label for="base_price">Precio base (USD o moneda que uses) *</label>
                    <input class="form-control" type="number" step="0.01" id="base_price" name="base_price" required>
                </div>
                <div class="form-group">
                    <label for="demo_url">URL del audio demo *</label>
                    <input class="form-control" type="text" id="demo_url" name="demo_url" placeholder="audio/mi_beat_demo.mp3" required>
                </div>
                <div class="form-group">
                    <label for="full_url">URL del audio completo *</label>
                    <input class="form-control" type="text" id="full_url" name="full_url" placeholder="audio/mi_beat_full.mp3" required>
                </div>
                <div class="form-group">
                    <label for="description">Descripción (opcional)</label>
                    <textarea class="form-control" id="description" name="description" rows="3" placeholder="Describe el mood, usos recomendados, referencias, etc."></textarea>
                </div>

                <div class="contract-box" style="margin-top:6px;">
                    <strong>Nota:</strong> Este formulario solo registra la información del beat. Aún necesitas subir los
                    archivos <code>.mp3</code> reales (demo y full) a la carpeta <code>/audio</code> del servidor con los
                    nombres que indiques aquí.
                </div>

                <div style="display:flex; justify-content:flex-end; gap:8px; margin-top:10px;">
                    <button type="submit" class="btn btn-primary">Guardar beat</button>
                </div>
            </div>
        </form>
    <?php endif; ?>
</div>
<?php
require_once 'footer.php';
