<?php
require_once 'config.php';
require_once 'header.php';

$allBeats = getAllBeats();
?>
<div class="hero">
    <div class="hero-text">
        <h1>Beatstore minimalista para vender tus instrumentales.</h1>
        <p>Organiza tus beats por estilos, ofrece licencias claras y deja que tus clientes descarguen el archivo completo después del pago.</p>
    </div>
    <div class="hero-pill">
        Home • Vista pública + demo de panel administrativo
    </div>
</div>

<section style="margin-bottom:22px;">
    <h2 style="font-size:15px; margin:0 0 10px;">Explora por vibra</h2>
    <p style="margin:0 0 12px; font-size:13px; color:var(--text-muted);">
        Un ejemplo visual de cómo podrías agrupar tus beats por tipo de mood o género.
    </p>
    <div class="category-grid">
        <a class="category-card" href="beats.php">
            <div class="category-overlay"></div>
            <div class="category-content">
                <div class="category-chip">Lo-fi & Chill</div>
                <div class="category-title">Beats para estudiar y relajarse</div>
                <div class="category-sub">Texturas cálidas, vinilo, pianos suaves.</div>
            </div>
        </a>
        <a class="category-card" href="beats.php">
            <div class="category-overlay"></div>
            <div class="category-content">
                <div class="category-chip">Trap & Drill</div>
                <div class="category-title">Bajos fuertes y 808 agresivos</div>
                <div class="category-sub">Ideal para artistas urbanos y freestyle.</div>
            </div>
        </a>
        <a class="category-card" href="beats.php">
            <div class="category-overlay"></div>
            <div class="category-content">
                <div class="category-chip">Afro & Dancehall</div>
                <div class="category-title">Ritmos bailables y latinos</div>
                <div class="category-sub">Perfecto para sencillos pegajosos.</div>
            </div>
        </a>
        <a class="category-card" href="beats.php">
            <div class="category-overlay"></div>
            <div class="category-content">
                <div class="category-chip">Cinematic</div>
                <div class="category-title">Beats para trailers y storytelling</div>
                <div class="category-sub">Ambientes épicos y emotivos.</div>
            </div>
        </a>
    </div>
</section>

<section>
    <h2 style="font-size:15px; margin:0 0 10px;">Últimos beats de ejemplo</h2>
    <p style="margin:0 0 12px; font-size:13px; color:var(--text-muted);">
        Estos beats están cargados desde el sistema (incluyendo los que crees en el panel admin).
    </p>
    <div class="card-grid">
        <?php
        $count = 0;
        foreach ($allBeats as $beat):
            if ($count >= 3) break;
            $count++;
        ?>
            <div class="card">
                <div class="card-header">
                    <div>
                        <div class="card-title"><?php echo e($beat['title']); ?></div>
                        <div class="meta">
                            <span><?php echo e($beat['genre']); ?></span>
                            <span><?php echo e($beat['bpm']); ?> BPM</span>
                        </div>
                    </div>
                    <div class="price-tag">
                        desde $<?php echo number_format($beat['base_price'], 2); ?>
                    </div>
                </div>
                <div class="description">
                    <?php echo e($beat['description']); ?>
                </div>
                <audio controls preload="none">
                    <source src="<?php echo e($beat['demo_url']); ?>" type="audio/mpeg">
                    Tu navegador no soporta el audio.
                </audio>
                <div style="display:flex; justify-content:space-between; align-items:center; gap:8px; margin-top:6px;">
                    <span class="pill">Demo</span>
                    <a class="btn btn-primary" href="beat.php?id=<?php echo $beat['id']; ?>">
                        Ver licencias
                    </a>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</section>
<?php
require_once 'footer.php';
